var Famark = Famark || {};

Famark.pageLoad = function () {
    Famark._propValues = {};

    Famark._divData = document.getElementById('divData');
    Famark._iframeView = document.getElementById('iframeView');
    Famark._iframeView.scrolling = 'no';
    Famark._iframeView.frameBorder = '0';

    Famark.addHandler(Famark._iframeView, 'load', function () { Famark._iframeView.style.visibility = 'visible'; });

    window.onbeforeunload = function () {
        if (Famark._isWorking && Famark._preventUnloadMessage)
            return Famark._preventUnloadMessage;
        return undefined;
    };

    Famark._btnShift = null;
    Famark._ddSelector = document.getElementById('ddSelector');

    if (Famark._ddSelector != null) {
        Famark._ddSelector.value = Famark._divData.getAttribute('data-prop');
        Famark._ddSelector.onchange = function () {
            Famark._divData.setAttribute('data-prop', Famark._ddSelector.value);
            var key = Famark._divData.getAttribute('data-entity') + '.prop.';
            Famark.setCookie(key, Famark._ddSelector.value, 60);
            if (Famark._btnShift != null)
                Famark._btnShift.disabled = (Famark._ddSelector.value.indexOf('.') == 0);
            Famark.setView();
        };

        if (window.top.Famark.relatedViewShifted != null) {
            Famark._btnShift = document.createElement('input');
            Famark._btnShift.type = 'button';
            Famark._btnShift.id = 'btnShift';
            Famark._btnShift.value = '<';
            var divTools = document.getElementById('divTools');
            divTools.insertBefore(Famark._btnShift, Famark._ddSelector);
            divTools.className = 'shifted';
            Famark._ddSelector.className = 'shifted';
            Famark._btnShift.disabled = (Famark._ddSelector.value.indexOf('.') == 0);
            Famark._btnShift.onclick = function () {
                if (Famark._ddSelector.selectedIndex >= 0 && Famark._ddSelector.value.indexOf('.') != 0)
                    window.top.Famark.relatedViewShifted(Famark._iframeView.src.replace('&mode=Related', '&'), Famark._ddSelector.options[Famark._ddSelector.selectedIndex].text);
            };
        }
    }

    Famark.addHandler(window, 'resize', Famark.screenLoad);
    Famark.screenLoad();

    Famark.loadPropValues();
    Famark.setView();
};
Famark._resizeTimeout = null;
Famark.screenLoad = function() {
    if (Famark._resizeTimeout)
        window.clearTimeout(Famark._resizeTimeout);
    Famark._resizeTimeout = window.setTimeout(function() {
        window.setTimeout(function() { Famark._iframeView.style.height = Famark._divData.style.height = (document.body.clientHeight - Famark._divData.offsetTop) + 'px'; }, 20);
        Famark._resizeTimeout = null;
    }, 100);
};
Famark.setView = function () {
    var prop = Famark._divData.getAttribute('data-prop');
    Famark._iframeView.style.visibility = 'hidden';

    if (prop[0] != '.') {
        var related = Famark._propValues[prop];
        Famark._iframeView.src = 'View.ashx?entity=' + related[0] + '&mode=Related&filter=' + window.encodeURIComponent(related[1]);
        return;
    }

    var entity = Famark._divData.getAttribute('data-entity');
    var rid = Famark._divData.getAttribute('data-rid');
    if (prop == '.properties')
        Famark._iframeView.src = 'View.ashx?entity=' + entity + '&mode=Properties&tools=hidden&filter=' + window.encodeURIComponent(entity + 'Id=' + rid);
    else if (prop == '.history')
        Famark._iframeView.src = 'Hist.ashx?entity=' + entity + '&rid=' + rid;
    else if (prop == '.documents')
        Famark._iframeView.src = 'List.ashx?entity=' + entity + '&rid=' + rid;
};
Famark.formRecordCreated = function (entity, rid, data) {
    var frames = window.frames;
    for (var i = 0; i < frames.length; i++) {
        if (frames[i].Famark != null && frames[i].Famark.formRecordCreated != null)
            frames[i].Famark.formRecordCreated(entity, rid, data);
    }
};
Famark.formRecordUpdated = function (entity, rid, data) {
    var frames = window.frames;
    for (var i = 0; i < frames.length; i++) {
        if (frames[i].Famark != null && frames[i].Famark.formRecordUpdated != null)
            frames[i].Famark.formRecordUpdated(entity, rid, data);
    }
};
Famark.setCookie = function (key, value, minutes) {
    value = window.escape(value);
    if (minutes != null) {
        var now = new Date();
        now.setMinutes(now.getMinutes() + minutes);
        value += '; expires=' + now.toUTCString();
    }
    document.cookie = key + "=" + value;
};
Famark.addHandler = function (el, ev, fn) {
    if (el.addEventListener)
        el.addEventListener(ev, fn, false);
    else if (el.attachEvent)
        el.attachEvent('on' + ev, fn);
    else
        el[ev] = fn;
};

Famark.setWorking = function (isWorking, msg) {
    Famark._isWorking  = isWorking;
    Famark._ddSelector.disabled = isWorking;
    Famark._preventUnloadMessage = msg;
};