var Famark = Famark || {};

Famark.pageLoad = function () {

    Famark._divUploadHtml = 'Upload';
    Famark._divUploadingHtml = 'Uploading...';
    Famark._deletedMessage = 'deleted!';
    Famark._isWorkingPrefex = 'Uploading "';
    Famark._isWorkingSuffix = '" please wait...';
    Famark._largeFileErrorMessage = 'Too large file(s)!';

    var frmMain = document.getElementById('frmMain');
    if (frmMain == null)
        return;

    var divData = document.getElementById('divData');
    var btnDel = document.getElementById('btnDel');
    var btnRef = document.getElementById('btnRef');

    var inFile = document.getElementById('inFile');
    var fileWrapperContent = document.getElementById('fileWrapperContent');
    fileWrapperContent.innerHTML = Famark._divUploadHtml;

    var workFrame = document.getElementById('workFrame');
    Famark.addHandler(workFrame, 'load', function () {
        var frameDoc = workFrame.contentDocument || workFrame.contentWindow.document;
        var result = {};
        try {
            result = Famark.parseJSON(frameDoc.body.innerHTML);
        } catch (e) {
            result.ErrorMessage = (frameDoc.body.innerHTML.indexOf('404') > 0) ? Famark._largeFileErrorMessage
                : (e.message.toLowerCase().indexOf('unexpected token <') > -1 ? Famark.htmlToText(frameDoc.body.innerHTML) : e.message);
        }
        if (result.ErrorMessage == null || result.ErrorMessage == '') {
            window.location.replace('List.ashx?entity=' + divData.getAttribute('data-entity') +
                    '&rid=' + divData.getAttribute('data-rid'));
        } else {
            alert(result.ErrorMessage);
            fileWrapperContent.innerHTML = Famark._divUploadHtml;
        }
        Famark._preventUnloadMessage = null;
        if (window.parent.Famark != null && window.parent.Famark.setWorking != null)
            window.parent.Famark.setWorking(false, Famark._preventUnloadMessage);
    });

    inFile.onchange = function () {
        if (inFile.value == '')
            return;

        inFile.style.visibility = 'hidden';
        fileWrapperContent.innerHTML = Famark._divUploadingHtml;
        Famark._preventUnloadMessage = Famark._isWorkingPrefex + inFile.value.substring(inFile.value.lastIndexOf('\\') + 1) + Famark._isWorkingSuffix;
        if (window.parent.Famark != null && window.parent.Famark.setWorking != null)
            window.parent.Famark.setWorking(true, Famark._preventUnloadMessage);

        Famark.removeHiddenFields(frmMain);

        Famark.appendHiddenFields(frmMain, 'entity', divData.getAttribute('data-entity'));
        Famark.appendHiddenFields(frmMain, 'work', 'UploadAttachment');
        Famark.appendHiddenFields(frmMain, 'rid', divData.getAttribute('data-rid'));
        frmMain.action = 'Work.ashx';
        frmMain.target = 'workFrame';
        frmMain.submit();
    };

    inFile.onfocus = function () {
        fileWrapperContent.className = 'fileWrapperFocus';
    };
    inFile.onblur = function () {
        fileWrapperContent.className = '';
    };

    divData.onclick = function (e) {
        e = e || window.event;
        var el = e.target || e.srcElement;

        while (el.nodeName != 'DIV' && el.nodeName != 'BODY')
            el = el.parentNode;

        if (el.nodeName != 'DIV')
            return;

        var file = el.getAttribute('data-file');

        if (file == null || file == '')
            return;

        var selId = divData.getAttribute('data-selected');

        if (e.ctrlKey == 1 && selId != null && selId != '') {
            var selPos = selId.indexOf(file);
            if (selPos > -1) {
                var nextPos = selId.indexOf('|', selPos + 1);
                if (nextPos < 0)
                    selId = selId.substring(0, selPos - 1);
                else
                    selId = selId.substring(0, selPos) + selId.substring(nextPos + 1);

                el.className = el.lastClassName;
                divData.setAttribute('data-selected', selId);
                return;
            }

            selId = selId + '|' + file;
        }
        else {
            if (selId != null && selId != '') {
                var items = Famark.getElementsByClassName('selected', 'div', divData);
                for (var i = 0; i < items.length; i++)
                    items[i].className = items[i].lastClassName;
            }
            selId = file;
        }

        el.lastClassName = el.className;
        el.className = 'selected';
        divData.setAttribute('data-selected', selId);
    };
    divData.ondblclick = function (e) {
        e = e || window.event;
        var el = e.target || e.srcElement;

        while (el.nodeName != 'DIV' && el.nodeName != 'BODY')
            el = el.parentNode;

        if (el.nodeName != 'DIV')
            return;

        var file = el.getAttribute('data-file');

        if (file == null || file == '')
            return;

        //prevent selection on dblclick
        Famark.clearSelection();

        var downFrame = document.getElementById('downFrame');

        downFrame.src = 'Attachment/' + divData.getAttribute('data-entity') +
            '/' + divData.getAttribute('data-rid') + '/' + window.encodeURIComponent(file) +
            '?type=' + window.encodeURIComponent('application/octet-stream');
    };
    
    if (btnDel != null) {
        btnDel.onclick = function () {
            var selId = divData.getAttribute('data-selected');
            if (selId == null || selId == '')
                return;

            var data = 'entity=' + divData.getAttribute('data-entity') +
                '&rid=' + divData.getAttribute('data-rid') +
                '&work=DeleteAttachment&files=' + window.encodeURIComponent(selId);

            var http = new XMLHttpRequest();
            http.open('POST', 'Work.ashx', false);
            http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            http.send(data);
            var result = Famark.parseJSON(http.responseText);
            if (result.ErrorMessage == null || result.ErrorMessage == '') {
                divData.setAttribute('data-selected', '');
                var items = Famark.getElementsByClassName('selected', 'div', divData);
                for (var i = 0; i < items.length; i++) {
                    items[i].className = 'deleted';
                    items[i].setAttribute('data-file', '');
                }
            } else
                alert(result.ErrorMessage);
        };
    }
    
    if (btnRef != null) {
        btnRef.onclick = function() {
            if (Famark._preventUnloadMessage) {
                alert(Famark._preventUnloadMessage);
                return;
            }
            window.location.replace('List.ashx?entity=' + divData.getAttribute('data-entity') +
                '&rid=' + divData.getAttribute('data-rid'));
        };
    }
    
    var screenLoad = function () {
        window.setTimeout(function () {
            var newHeight = document.body.clientHeight - divData.offsetTop;
            if (newHeight < 0)
                newHeight = 0;
            divData.style.height = newHeight + 'px';
        }, 40);
    };

    Famark.addHandler(window, 'resize', screenLoad);

    screenLoad();
};
Famark.htmlToText = function (html) {
    var div = document.createElement('div');
    div.innerHTML = html;
    return div.textContent;
};
Famark.removeHiddenFields = function (frm) {
    var fields = frm.getElementsByTagName('input');
    var hdFields = [];

    for (var i = 0; i < fields.length; i++) {
        if (fields[i].type == 'hidden')
            hdFields.push(fields[i]);
    }

    for (var j = 0; j < hdFields.length; j++)
        frm.removeChild(hdFields[j]);
};
Famark.appendHiddenFields = function (frm, name, value) {
    var el = document.createElement('input');
    el.type = 'hidden';
    el.name = name;
    el.value = value;
    frm.appendChild(el);
};

Famark.addHandler = function (el, ev, fn) {
    if (el.addEventListener)
        el.addEventListener(ev, fn, false);
    else if (el.attachEvent)
        el.attachEvent('on' + ev, fn);
    else
        el[ev] = fn;
};

Famark.parseJSON = function (data) {
    if (data == null || typeof data !== 'string')
        return null;

    data = (data.trim) ? data.trim() : data.replace(/^\s+|\s+$/g, '');

    if (window.JSON && window.JSON.parse)
        return window.JSON.parse(data);

    var valData = data.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@');
    valData = valData.replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']');
    valData = valData.replace(/(?:^|:|,)(?:\s*\[)+/g, '');

    var valExp = /^[\],:{}\s]*$/;

    if (valExp.test(valData))
        return (new Function('return ' + data))();

    alert('Invalid JSON: ' + data);
    return null;
};

Famark.getElementsByClassName = function (cName, tName, node) {
    var els = [];
    var tmp, i;

    tName = tName || '*';
    node = node || document;

    if (node.getElementsByClassName) {
        tmp = node.getElementsByClassName(cName);
        for (i = 0; i < tmp.length; i++)
            els.push(tmp[i]);
    }
    else {
        var pattern = new RegExp('\\b' + cName + '\\b');
        tmp = node.getElementsByTagName(tName);
        for (i = 0; i < tmp.length; i++) {
            if (pattern.test(tmp[i].className))
                els.push(tmp[i]);
        }
    }

    return els;
};

Famark.clearSelection = function () {
    if (document.selection && document.selection.empty) {
        try {
            document.selection.empty();
        } catch (e) { }
    } else if (window.getSelection) {
        var sel = window.getSelection();
        sel.removeAllRanges();
    }
};