@echo off

:: Check for admin rights by trying to create a folder in system32 (or check membership)
>nul 2>&1 "%SystemRoot%\system32\cacls.exe" "%SystemRoot%\system32\config\system"

if '%errorlevel%' NEQ '0' (
    echo.
    echo *** This Setup requires Administrator privileges ***
    echo Please right-click Setup-3-FamarkUrlAccess and select "Run as administrator".
    echo.
    pause
    exit /b
)

:: Needed for iterating files
setlocal enabledelayedexpansion

:: Change Directory back to FamarkCloud\App directory
@cd /d "%~dp0App"

:: Add urlacl for self hosted web services
for %%F in ("..\Host\*.svc") do (
    call :DeleteUrlAclIfExists http://+:8092/%%~nxF
    netsh http add urlacl url=http://+:8092/%%~nxF user=Everyone
)

:: NOT NEEDED urlacl for Httplistener running localhost:8091
:: call :DeleteUrlAclIfExists http://localhost:8091/
:: netsh http add urlacl url=http://localhost:8091/ user=Everyone

:: NOT NEEDED urlacl for Httplistener running localhost:8090
:: call :DeleteUrlAclIfExists http://localhost:8090/
:: netsh http add urlacl url=http://localhost:8090/ user=Everyone

:: Unblock Downloaded Binaries

powershell.exe -Command "Get-ChildItem -Path '%~dp0' -Recurse | Unblock-File"

:: Launch Famark Cloud App
Famark.Cloud.App.exe

echo.
pause

:: === Function Definition ===
:DeleteUrlAclIfExists
set "TARGET_URL=%~1"
set "FOUND=false"

:: Check if the URL reservation exists
netsh http show urlacl | findstr /i "%TARGET_URL%" >nul
if %errorlevel%==0 (
    echo Deleting URL reservation: %TARGET_URL%
    netsh http delete urlacl url=%TARGET_URL%
)
GOTO :EOF
