@echo off

:: Check for admin rights by trying to create a folder in system32 (or check membership)
>nul 2>&1 "%SystemRoot%\system32\cacls.exe" "%SystemRoot%\system32\config\system"

if '%errorlevel%' NEQ '0' (
    echo.
    echo *** This Setup requires Administrator privileges ***
    echo Please right-click Setup-2-FamarkShortcut and select "Run as administrator".
    echo.
    pause
    exit /b
)

:: Get the current directory (where the batch file resides)
set "CURRENT_DIR=%~dp0App\"
set "TARGET=%CURRENT_DIR%Famark.Cloud.App.exe"
set "SHORTCUT_NAME=Famark.Cloud.App"
set "USERS_DESKTOP=%Public%\Desktop"

:: For Current User Desktop Only (uncomment following)
:: for /f "usebackq delims=" %%a in (`powershell -NoProfile -Command "[Environment]::GetFolderPath('Desktop')"`) do set "USERS_DESKTOP=%%a"

:: Use PowerShell to create the shortcut on Desktop
powershell -nologo -command ^
  "$s = (New-Object -COM WScript.Shell).CreateShortcut('%USERS_DESKTOP%\%SHORTCUT_NAME%.lnk');" ^
  "$s.TargetPath = '%TARGET%';" ^
  "$s.WorkingDirectory = '%CURRENT_DIR%';" ^
  "$s.IconLocation = '%TARGET%,0';" ^
  "$s.Save()"

echo.
pause