var Famark = Famark || {};

function performInstall(e, file) {
    var importUrl = Famark._subscriptionUrl + 'Solution.ashx?file=' + file;

    if (isIframed()) {
        window.parent.postMessage(importUrl, '*');
        return;
    }

    document.cookie = 'ImportSolution=' + window.escape(importUrl) + ';path=/';

    e = e || window.event;
    var target = e.target || e.srcElement;
    while (target.nodeName != 'BODY' && target.className != 'soln') {
        target = target.parentNode;
    }

    if (target.nodeName == 'BODY')
        return;

    var prompt = document.getElementById('prompt');
    prompt.parentNode.removeChild(prompt);
    target.appendChild(prompt);
    prompt.style.display = 'table';

    document.getElementById('enterDomainName').style.display = 'none';
}

function isIframed() {
    try {
        return window.self !== window.top;
    } catch (e) {
        return true;
    }
}

function btnHaveClick() {
    document.getElementById('enterDomainName').style.display = 'block';
    document.getElementById("txtDomainName").focus();
}

function btnCloseClick() {
    document.getElementById('prompt').style.display = 'none';
}

function btnCreateClick() {
    window.location = Famark._subscriptionUrl + '?ic=' + Famark._defaultInviteCode;
}

function btnContinueClick() {
    var txtDomainName = document.getElementById("txtDomainName");
    var domainMatch = txtDomainName.value.match(/^[a-zA-Z0-9]+$/);
    if (domainMatch == null) {
        alert('Domain Name can be alphanumeric only.');
        txtDomainName.focus();
        return;
    }
    window.location = Famark._appRootUrl + txtDomainName.value + '/MainSite/';
}

function txtDomainKeyPress(e) {
    e = e || window.event;
    if (e.keyCode == 13)
        btnContinueClick();
}

function setEventHandler(eventName, handler) {
    if (window.addEventListener)
        window.addEventListener(eventName, handler, false);
    else if (window.attachEvent)
        window.attachEvent('on' + eventName, handler);
    else
        window[eventName] = handler;
}

var _resizeTimeout = null;
function screenLoad() {
    if (_resizeTimeout)
        window.clearTimeout(_resizeTimeout);
    _resizeTimeout = window.setTimeout(function () {
        window.setTimeout(function () {
            var mainContainer = document.getElementById('mainContainer');
            mainContainer.style.height = (document.documentElement.clientHeight - mainContainer.offsetTop) + 'px';
        }, 40);
        _resizeTimeout = null;
    }, 100);
}

setEventHandler('resize', screenLoad);
setEventHandler('load', screenLoad);
