function validateFunction(e) {
    if (e == null) e = window.event;

    var txtEmail = document.getElementById("txtEmail");
    var txtPhone = document.getElementById("txtPhone");
    var txtFullName = document.getElementById("txtFullName");
    var txtUserName = document.getElementById("txtUserName");
    var txtPassword = document.getElementById("txtPassword");
    var txtConfirmPassword = document.getElementById("txtConfirmPassword");
    
    if (txtEmail.value == "") {
        return invalidValue(txtEmail, e, Resources.LabelEmailAddress + Resources.InvalidCannotBeBlank);
    }

    var emailPattern = /^[a-zA-Z0-9_\.\-\+%&]+@[a-zA-Z0-9\.\-]+\.[a-zA-Z][a-zA-Z]+$/;
    var emailAddress = txtEmail.value;
    var emailMatch = emailAddress.match(emailPattern);
    if (emailMatch == null) {
        return invalidValue(txtEmail, e, Resources.LabelEmailAddress + Resources.InvalidIsIncorrect);
    }

    if (txtPhone.value == "") {
        return invalidValue(txtPhone, e, Resources.LabelPhoneNumber + Resources.InvalidCannotBeBlank);
    }

    if (txtFullName.value == "") {
        return invalidValue(txtFullName, e, Resources.LabelFullName + Resources.InvalidCannotBeBlank);
    }

    var fullName = txtFullName.value;
    var namePattern = /[\<\>&"']+/;
    var nameMatch = fullName.match(namePattern);
    if (nameMatch != null) {
        return invalidValue(txtFullName, e, Resources.LabelFullName + Resources.InvalidCannotContain + '< > & \' "');
    }

    if (txtUserName.value == "") {
        return invalidValue(txtUserName, e, Resources.LabelUserName + Resources.InvalidCannotBeBlank);
    }

    var userName = txtUserName.value;
    var alphaNumeric = /^[a-zA-Z0-9]+$/;
    var domainMatch = userName.match(alphaNumeric);
    if (domainMatch == null) {
        return invalidValue(txtUserName, e, Resources.LabelUserName + Resources.InvalidMustBeAlphanumeric);
    }

    if (txtPassword.value == "") {
        return invalidValue(txtPassword, e, Resources.LabelPassword + Resources.InvalidCannotBeBlank);
    }

    if (txtConfirmPassword.value != txtPassword.value) {
        return invalidValue(txtConfirmPassword, e, Resources.LabelConfirmPassword + Resources.InvalidIsIncorrect);
    }
    
    document.getElementById("lblMessage").innerHTML = "";
    return true;
}

function invalidValue(element, e, message) {
    var lblMessage = document.getElementById("lblMessage");
    lblMessage.innerHTML = message;
    element.focus();
    e.returnValue = false;
    return false;
}