
var _pageLoaded = false;
var _url = null;

function pageLoad() {
    if (!_pageLoaded) {
        _url = window.location.href;
        _url = _url.substr(_url.lastIndexOf('/') + 1);

        showDialog('divSystemDialog', null);
        startInstall(280, Resources._stepsArray); //Total 28
        _pageLoaded = true;
    }
}

function onNext() { window.location = 'RegisterUser.ashx'; }

var Famark = Famark || {};
var _progress;
var _messages;

function startInstall(width, messages) {
    setProgressWidth(width);
    _messages = messages;
    _progress = width / messages.length;
    var btnInstall = document.getElementById("btnInstall");
    btnInstall.disabled = true;
    btnInstall.value = Resources.LabelWait;
    installStep(0);
}

function setProgressWidth(width) {
    var dynWidth = width + 'px';
    var container = document.getElementById("progressContainer");
    container.style.width = dynWidth;
}

function installStep(step) {
    var messageDiv = document.getElementById("messageDiv");
    messageDiv.innerHTML = _messages[step] + '...';
    var http = new XMLHttpRequest();
    http.open('POST', _url, true);
    http.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    http.onreadystatechange = function () {
        if (http.readyState == 4 && http.status == 200) {
            var result = Famark.parseJSON(http.responseText);
            onStepComplete(result);
        }
    }
    http.send('step=' + step);
}

function onStepComplete(result) {
    var stepCount = parseInt(result.StepCount);

    if (stepCount >= 0) {
        var progressDiv = document.getElementById("progressDiv");
        stepCount++;
        progressDiv.style.width = ((stepCount * _progress) + 'px');
        if (stepCount < _messages.length) {
            installStep(stepCount);
        } else {
            var messageDiv = document.getElementById("messageDiv");
            messageDiv.innerHTML = Resources.LabelCompleted;
            var btnInstall = document.getElementById("btnInstall");
            btnInstall.disabled = false;
            btnInstall.value = Resources.LabelNext;
            btnInstall.focus();
        }
    }
    else {
        document.getElementById("lblMessage").innerHTML = result.ErrorMessage;
        document.getElementById("btnInstall").value = Resources.LabelFailed;
    }
}

Famark.parseJSON = function (data) {
    if (data == null || typeof data !== 'string')
        return null;

    data = (data.trim) ? data.trim() : data.replace(/^\s+|\s+$/g, '');

    if (window.JSON && window.JSON.parse) {
        try {
            return window.JSON.parse(data);
        } catch (e) {
            alert('Invalid JSON: ' + data);
            return null;
        }
    }
    var valData = data.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@');
    valData = valData.replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']');
    valData = valData.replace(/(?:^|:|,)(?:\s*\[)+/g, '');

    var valExp = /^[\],:{}\s]*$/;

    if (valExp.test(valData))
        return (new Function('return ' + data))();

    alert('Invalid JSON: ' + data);
    return null;
};