function validateFunction(e) {
    if (e == null) e = window.event;

    var txtEmail = document.getElementById("txtEmail");
    var txtFullName = document.getElementById("txtFullName");
    var txtDomainName = document.getElementById("txtDomainName");

    var txtDatabaseServer = document.getElementById("txtDatabaseServer");
    var ddDatabaseAuth = document.getElementById("ddDatabaseAuth");
    var txtDatabaseUser = document.getElementById("txtDatabaseUser");
    var txtDatabasePwd = document.getElementById("txtDatabasePwd");

    var txtCaptcha = document.getElementById("txtCaptcha");
    var chkAgree = document.getElementById("chkAgree");
    
    if (txtEmail.value == "") {
        return invalidValue(txtEmail, e, Resources.LabelEmailAddress + Resources.InvalidCannotBeBlank);
    }

    var emailPattern = /^[a-zA-Z0-9_\.\-\+%&]+@[a-zA-Z0-9\.\-]+\.[a-zA-Z][a-zA-Z]+$/;
    var emailId = txtEmail.value;
    var emailMatch = emailId.match(emailPattern);

    if (emailMatch == null)
        return invalidValue(txtEmail, e, Resources.LabelEmailAddress + Resources.InvalidIsIncorrect);

    if (txtFullName.value == "")
        return invalidValue(txtFullName, e, Resources.LabelCompanyName + Resources.InvalidCannotBeBlank);

    var fullName = txtFullName.value;
    var namePattern = /[\<\>"']+/;
    var nameMatch = fullName.match(namePattern);
    if (nameMatch != null)
        return invalidValue(txtFullName, e, Resources.LabelCompanyName + Resources.InvalidCannotContain + '< > \' "');

    if (txtDomainName.value == "")
        return invalidValue(txtDomainName, e, Resources.LabelDomainName + Resources.InvalidCannotBeBlank);

    var domainName = txtDomainName.value;
    var alphaNumeric = /^[a-zA-Z0-9]+$/;
    var domainMatch = domainName.match(alphaNumeric);
    if (domainMatch == null)
        return invalidValue(txtDomainName, e, Resources.LabelDomainName + Resources.InvalidMustBeAlphanumeric);

    if (txtDatabaseServer && txtDatabaseServer.value == "")
        return invalidValue(txtDatabaseServer, e, Resources.LabelDatabaseServer + Resources.InvalidCannotBeBlank);

    if (ddDatabaseAuth && ddDatabaseAuth.value != "2") {
        if(txtDatabaseUser.value == "")
            return invalidValue(txtDatabaseUser, e, Resources.LabelDatabaseUser + Resources.InvalidCannotBeBlank);
        if (txtDatabasePwd.value == "")
            return invalidValue(txtDatabasePwd, e, Resources.LabelDatabasePwd + Resources.InvalidCannotBeBlank);
    }

    if (txtCaptcha && txtCaptcha.value == "")
        return invalidValue(txtCaptcha, e, Resources.LabelCaptchaText + Resources.InvalidCannotBeBlank);

    if (!chkAgree.checked)
        return invalidValue(chkAgree, e, Resources.InvalidAcceptTerms);
        
    document.getElementById("lblMessage").innerHTML = Resources.MessagePleaseWait;
    return true;
}

function invalidValue(element, e, message) {
    var lblMessage = document.getElementById("lblMessage");
    lblMessage.innerHTML = message;
    element.focus();
    e.returnValue = false;
    return false;
}

function ddDatabaseAuthChange() {
    var visibility = (document.getElementById("ddDatabaseAuth").value == "2") ? 'hidden' : 'visible';
    document.getElementById("lblDatabaseUser").style.visibility = visibility;
    document.getElementById("txtDatabaseUser").style.visibility = visibility;
    document.getElementById("lblDatabasePwd").style.visibility = visibility;
    document.getElementById("txtDatabasePwd").style.visibility = visibility;
}

function clearControl(e) {
    if (!e) e = window.event;
    e.returnValue = false;

    var txtDatabaseServer = document.getElementById("txtDatabaseServer");
    var ddDatabaseAuth = document.getElementById("ddDatabaseAuth");
    var txtDatabaseUser = document.getElementById("txtDatabaseUser");
    var txtDatabasePwd = document.getElementById("txtDatabasePwd");

    if (txtDatabaseServer)
        txtDatabaseServer.value = "";
    if (ddDatabaseAuth)
        ddDatabaseAuth.value = "1";
    if (txtDatabaseUser)
        txtDatabaseUser.value = "";
    if (txtDatabasePwd)
        txtDatabasePwd.value = "";

    var imgCaptcha = document.getElementById("imgCaptcha");
    var txtCaptcha = document.getElementById("txtCaptcha");
    
    if(imgCaptcha)
        imgCaptcha.src = "Captcha.ashx?r=" + Math.random();
    if(txtCaptcha)
        txtCaptcha.value = "";
    
    document.getElementById("txtEmail").value = "";
    document.getElementById("txtDomainName").value = "";
    document.getElementById("txtFullName").value = "";
    document.getElementById("lblMessage").innerHTML = "";
    window.history.back();
    return false;
}