function validateFunction(e) {
    if (e == null) e = window.event;

    var txtEmail = document.getElementById("txtEmail");
    var txtPhone = document.getElementById("txtPhone");
    var txtFullName = document.getElementById("txtFullName");
    var txtActivationCode = document.getElementById("txtActivationCode");
    var txtCaptcha = document.getElementById("txtCaptcha");
    var chkAgree = document.getElementById("chkAgree");
    
    if (txtEmail.value == "") {
        return invalidValue(txtEmail, e, Resources.LabelEmailAddress + Resources.InvalidCannotBeBlank);
    }

    var emailPattern = /^[a-zA-Z0-9_\.\-\+%&]+@[a-zA-Z0-9\.\-]+\.[a-zA-Z][a-zA-Z]+$/;
    var emailAddress = txtEmail.value;
    var emailMatch = emailAddress.match(emailPattern);
    if (emailMatch == null) {
        return invalidValue(txtEmail, e, Resources.LabelEmailAddress + Resources.InvalidIsIncorrect);
    }

    if (txtPhone.value == "") {
        return invalidValue(txtPhone, e, Resources.LabelPhoneNumber + Resources.InvalidCannotBeBlank);
    }

    if (txtFullName.value == "") {
        return invalidValue(txtFullName, e, Resources.LabelFullName + Resources.InvalidCannotBeBlank);
    }

    var fullName = txtFullName.value;
    var namePattern = /[\<\>&"']+/;
    var nameMatch = fullName.match(namePattern);
    if (nameMatch != null) {
        return invalidValue(txtFullName, e, Resources.LabelFullName + Resources.InvalidCannotContain + '< > & \' "');
    }

    if (txtActivationCode.value == "") {
        return invalidValue(txtActivationCode, e, Resources.LabelActivationCode + Resources.InvalidCannotBeBlank);
    }

    var activationCode = txtActivationCode.value;
    var codePattern = /^[a-zA-Z0-9]{8}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{12}$/;
    var codeMatch = activationCode.match(codePattern);
    if (codeMatch == null) {
        return invalidValue(txtActivationCode, e, Resources.LabelActivationCode + Resources.InvalidIsIncorrect);
    }

    if (txtCaptcha && txtCaptcha.value == "")
        return invalidValue(txtCaptcha, e, Resources.LabelCaptchaText + Resources.InvalidCannotBeBlank);

    if (!chkAgree.checked)
        return invalidValue(chkAgree, e, Resources.InvalidAcceptTerms);

    document.getElementById("lblMessage").innerHTML = Resources.MessagePleaseWait;
    return true;
}

function invalidValue(element, e, message) {
    var lblMessage = document.getElementById("lblMessage");
    lblMessage.innerHTML = message;
    element.focus();
    e.returnValue = false;
    return false;
}

function clearControl(e) {
    if (!e) e = window.event;
    e.returnValue = false;

    var imgCaptcha = document.getElementById("imgCaptcha");
    var txtCaptcha = document.getElementById("txtCaptcha");
    imgCaptcha.src = "Captcha.ashx?r=" + Math.random();
    txtCaptcha.value = "";
    document.getElementById("lblMessage").innerHTML = "";
    window.history.back();
    return false;
}